
  /*
   *  Object %name    : main.c%
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the KMNG parsing functions  
   *
   *  \version parser.c#1:csrc:1
   *  \author mottig
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include <stdio.h>
#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "kmngatptest_msg_defs.h"
#include "CRYS_SEP_ATP_Defines.h"
#include "DX_VOS_Mem.h"
#include "KMNG_SEP_ATP_KeysOp.h"

// temp
//#include "gen_release.h"
//#include "sep_hw_defs.h"
//#include "cache_defs.h"


/************************ Defines ****************************/
/************************ Enums ******************************/
/************************ Typedefs ***************************/
/************************ Global Data ************************/
extern TST_Ext_KeysSym_TestDataStruct *SEP_KeysOpSym_TestData;
extern DxUint8_t   FailureFunctionNameOut[TST_FUNC_STRING_LEN];
/**************** Private function prototypes ****************/

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_KMNG_AESImportExportSymKeys

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* RND test without reset.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_KMNG_ImportExportSymKeys(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;
	DxUint16_t	SEP_RNDSize;
	
	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;
	

	/* 1. Allocate memory buffers */
	/******************************/
	SEP_KeysOpSym_TestData = DX_VOS_MemMalloc(sizeof(TST_Ext_KeysSym_TestDataStruct));

	if (SEP_KeysOpSym_TestData == DX_NULL)
	{

		SEP_Error = SEPQA_ATP_CheckErrorReturn(TESTFAIL,
			"DX_VOS_MemMalloc",
			FailureFunctionNameOut);

		goto End;                                                                       
	}

	/* 1. extract parameters from the message */
	/******************************************/
	DX_VOS_FastMemCpy(&SEP_KeysOpSym_TestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_Ext_KeysSym_TestDataStruct));


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = sizeof(TST_Ext_KeysSym_TestDataStruct)/4 + DX_SEP_HOST_SEP_BASE_MSG_OFFSET;
		
	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEP_KMNG_ATP_Ext_ImportExportSymKeys();
		

	//if(SEP_Error != CRYS_OK)
	//{
	//	/* output parameters are placed after msg RC */
	//	DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
	//	SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	//}

End:
	/* 6. Free allocated buffers */
	DX_VOS_MemFree(SEP_KeysOpSym_TestData);

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}






